// The module 'vscode' contains the VS Code extensibility API
// Import the module and reference it with the alias vscode in your code below
import * as vscode from 'vscode';

// This method is called when your extension is activated
// Your extension is activated the very first time the command is executed
export function activate(context: vscode.ExtensionContext) {

	// Use the console to output diagnostic information (console.log) and errors (console.error)
	// This line of code will only be executed once when your extension is activated
	console.log('Congratulations, your extension "test-extension-sample" is now active!');

	const testController = vscode.tests.createTestController('sample-controller', 'test-extension-sample-controller');
	context.subscriptions.push(testController);
	console.log(testController);

	const rootItem = testController.createTestItem('sample-root', 'sample-root');
	rootItem.description='sample description for root item';
	testController.items.add(rootItem);

	const child1 = testController.createTestItem('sample-root.child1', 'sample-child1');
	child1.description='sample description for child1';
	rootItem.children.add(child1);
	const child2 = testController.createTestItem('sample-root.child2', 'sample-child2');
	child2.description='sample description for child2';
	rootItem.children.add(child2);

	context.subscriptions.push(vscode.commands.registerCommand('test-extension-sample.create-test-run-Profile', () => {
		const testRunProfile= createTestRunProfile(testController);
		vscode.window.showInformationMessage(`Test Run Profile Created: ${testRunProfile}`);
		
	}));

	context.subscriptions.push(vscode.commands.registerCommand('test-extension-sample.message-context', (args) => {
		vscode.window.showInformationMessage(`Message Context with args: ${args}`);
	}));

	context.subscriptions.push(vscode.commands.registerCommand('test-extension-sample.message-content', (args) => {
		vscode.window.showInformationMessage(`Message Content with args: ${args}`);
	}));
}

export function createTestRunProfile(testController: vscode.TestController) : vscode.TestRunProfile {
	return testController.createRunProfile('sample-run-profile', vscode.TestRunProfileKind.Run, (request, token) => {
		const run = testController.createTestRun(request);
		const queue: vscode.TestItem[] = [];
	  
		// Loop through all included tests, or all known tests, and add them to our queue
		if (request.include) {
		  request.include.forEach(test => queue.push(test));
		} else {
		  testController.items.forEach(test => queue.push(test));
		}
	  
		// For every test that was queued, try to run it. Call run.passed() or run.failed().
		// The `TestMessage` can contain extra information, like a failing location or
		// a diff output. But here we'll just give it a textual message.
		while (queue.length > 0 && !token.isCancellationRequested) {
		  const test = queue.pop()!;
	  
		  // Skip tests the user asked to exclude
		  if (request.exclude?.includes(test)) {
			continue;
		  }
	  
		  switch(test.id) {
			case "sample-root.child1":
				run.passed(test);
				break;
			case "sample-root.child2":
				run.failed(test, {
					message: "Fail message",
					actualOutput: "actual",
					expectedOutput: "expected",
					contextValue: "context-value"
				});
				break;
			default: 
				run.passed(test);
		  }
	  
		  test.children.forEach(test => queue.push(test));
		}
	  
		// Make sure to end the run after all tests have been executed:
		run.end();
	  }

	);
}

function stringify(obj: any) {
	let cache : any = [];
	let str = JSON.stringify(obj, function(key, value) {
	  if (typeof value === "object" && value !== null) {
		if (cache.indexOf(value) !== -1) {
		  // Circular reference found, discard key
		  return;
		}
		// Store value in our collection
		cache.push(value);
	  }
	  return value;
	});
	cache = null; // reset the cache
	return str;
  }

// This method is called when your extension is deactivated
export function deactivate() {}
